/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: b_ioctl.h
 * -----------------------------------------------------------------*/

#ifndef B_IOCTL_H_INCLUDED
#define B_IOCTL_H_INCLUDED

#ifndef LINUX
  #if (DEVL == 1)     /* device driver compile */
    #include <ntdef.h>
  #else
    #include <windows.h>
  #endif              /* DEVL */
#else
  typedef unsigned short USHORT;
  typedef unsigned char UCHAR;
  typedef void *PVOID;
  #define PHYSICAL_ADDRESS SPhysicalAddress
  typedef unsigned long ULONG;
#endif                /* LINUX */

/* Define the IOCTL codes we will use.  The IOCTL code contains a command */
/* identifier, plus other information about the device, the type of access */
/* with which the file must have been opened, and the type of buffering. */

/* Device type           -- in the "User Defined" range." */

#define NTIO_TYPE_EPP (ULONG)40000
#define NTIO_TYPE_PCI (ULONG)41000
#define NTIO_TYPE_IO  (ULONG)42000

/* return status definitions */
/* bit 29 must be set in order to mark this as application specific code */

#define B_DRIVER_STATUS_PCI_NO_SLOT_SELECTED   0xf0000001UL
#define B_DRIVER_STATUS_PCI_NO_TARGET_RESPONSE 0xf0000002UL


/* The IOCTL function codes from 0x800 to 0xFFF are for customer use. */

#define BEST_NTMEM_IOCTL_INDEX  0x800


#ifdef LINUX

# define IOCTL_NTIO_READ_PORT_UCHAR          0x00
# define IOCTL_NTIO_READ_PORT_USHORT         0x01
# define IOCTL_NTIO_READ_PORT_ULONG          0x02
# define IOCTL_NTIO_WRITE_PORT_UCHAR         0x03
# define IOCTL_NTIO_WRITE_PORT_USHORT        0x04
# define IOCTL_NTIO_WRITE_PORT_ULONG         0x05
# define IOCTL_NTIO_SET_REGWIDTH             0x06
# define IOCTL_NTIO_GET_PHYSICAL_ADDRESS     0x07
# define IOCTL_NTIO_GET_CONFIG_DW            0x08
# define IOCTL_NTIO_SET_CONFIG_DW            0x09
# define IOCTL_NTIO_SET_DIRECT_IO            0x0A
# define IOCTL_NTIO_SET_HAL_IO               0x0B
# define IOCTL_NTIO_SET_TIMEOUT              0x0C
# define IOCTL_NTIO_SET_REGWIDTH_PCI         0x0D
# define IOCTL_NTIO_GET_PHYSICAL_ADDRESS_PCI 0x0E
# define IOCTL_NTIO_GET_BASE_ADDR            0x0F
# define IOCTL_NTIO_READ_REG_DW              0x10
# define IOCTL_NTIO_WRITE_REG_DW             0x11

#else

/* this are IOCTLs for EPP driver */

#define IOCTL_NTIO_READ_PORT_UCHAR \
    CTL_CODE( NTIO_TYPE_EPP, 0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_READ_PORT_USHORT \
    CTL_CODE( NTIO_TYPE_EPP, 0x901, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_READ_PORT_ULONG \
    CTL_CODE( NTIO_TYPE_EPP, 0x902, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_WRITE_PORT_UCHAR \
    CTL_CODE(NTIO_TYPE_EPP,  0x910, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_NTIO_WRITE_PORT_USHORT \
    CTL_CODE(NTIO_TYPE_EPP,  0x911, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_NTIO_WRITE_PORT_ULONG \
    CTL_CODE(NTIO_TYPE_EPP,  0x912, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_NTIO_SET_REGWIDTH \
    CTL_CODE(NTIO_TYPE_EPP,  0x920, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_NTIO_GET_PHYSICAL_ADDRESS \
    CTL_CODE( NTIO_TYPE_EPP, 0x930, METHOD_BUFFERED, FILE_READ_ACCESS )



/* ---------- this IOCTLs are for the PCI driver ------------- */

#define IOCTL_NTIO_GET_CONFIG_DW \
    CTL_CODE( NTIO_TYPE_PCI, 0x940, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_SET_CONFIG_DW \
    CTL_CODE( NTIO_TYPE_PCI, 0x941, METHOD_BUFFERED, FILE_WRITE_ACCESS )

/*
// the next two codes only alter the way in which the driver reads 
// and have no effect on the card itself.  (Error returned if direct IO not
// allowed or not enabled.
*/
#define IOCTL_NTIO_SET_DIRECT_IO \
    CTL_CODE( NTIO_TYPE_PCI, 0x942, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_NTIO_SET_HAL_IO \
    CTL_CODE( NTIO_TYPE_PCI, 0x943, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_NTIO_SET_TIMEOUT \
    CTL_CODE( NTIO_TYPE_PCI, 0x944, METHOD_BUFFERED, FILE_WRITE_ACCESS )



#define IOCTL_NTIO_SET_REGWIDTH_PCI \
    CTL_CODE( NTIO_TYPE_PCI, 0x946, METHOD_BUFFERED, FILE_WRITE_ACCESS)

#define IOCTL_NTIO_GET_PHYSICAL_ADDRESS_PCI \
    CTL_CODE( NTIO_TYPE_PCI, 0x947, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_GET_BASE_ADDR \
    CTL_CODE( NTIO_TYPE_PCI, 0x950, METHOD_BUFFERED, FILE_READ_ACCESS )


/* the following two commands are used for Mephisto's access port */
#define IOCTL_NTIO_READ_REG_DW \
    CTL_CODE( NTIO_TYPE_PCI, 0x951, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_NTIO_WRITE_REG_DW \
    CTL_CODE( NTIO_TYPE_PCI, 0x952, METHOD_BUFFERED, FILE_WRITE_ACCESS )


/* these are used to access the memory-driver-functions in pci-driver */

#define IOCTL_BEST_NTMEM_MAP_USER_PHYSICAL_MEMORY \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_BEST_NTMEM_UNMAP_USER_PHYSICAL_MEMORY \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX+1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_BEST_NTMEM_IO_ACCESS \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX+3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_BEST_NTMEM_GET_VERSIONDATE \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX+4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_BEST_NTMEM_FREE_PHYSICAL_MEMORY \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX+5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_BEST_NTMEM_ALLOC_PHYSICAL_MEMORY \
    CTL_CODE( NTIO_TYPE_PCI, BEST_NTMEM_IOCTL_INDEX+6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif /* LINUX */


typedef union {               /* Data to be output to port */
    ULONG   LongData;
    USHORT  ShortData;
    UCHAR   CharData;
} t_Data;

typedef struct  {
    ULONG   PortNumber;     /* Port # to write to */
    t_Data  Data;
} BESTNTIO_WRITE_INPUT;

typedef union {
    ULONG Data;
    UCHAR Byte;
} conf_data;

typedef struct {
    ULONG Offset;
    conf_data Data;
} b_configdrivertype;

typedef struct {
  ULONG m_dwAddress; /* address to access */
  UCHAR m_cRegWidth; /* width of register */
} b_accessporttype;

typedef struct {
  b_accessporttype m_port;
  ULONG m_data;  /* data to transfer */
} b_accessportdatatype;
  

#endif

